terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }
}

provider "aws" {
  region = "us-east-2"
}

resource "aws_instance" "example" {
  ami           = "ami-0fb653ca2d3203ac1"
  instance_type = "t2.micro"

  # Dołączenie profilu egzemplarza.
  iam_instance_profile = aws_iam_instance_profile.instance.name
}

# Utworzenie roli IAM.
resource "aws_iam_role" "instance" {
  name_prefix        = var.name
  assume_role_policy = data.aws_iam_policy_document.assume_role.json
}

# Umożliwienie przyjęcia roli IAM przez egzemplarze EC2.
data "aws_iam_policy_document" "assume_role" {
  statement {
    effect  = "Allow"
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

# Dołączenie do roli IAM uprawnień administracyjnych EC2.
resource "aws_iam_role_policy" "example" {
  role   = aws_iam_role.instance.id
  policy = data.aws_iam_policy_document.ec2_admin_permissions.json
}

# Utworzenie polityki IAM nadającej uprawnienia administracyjne EC2.
data "aws_iam_policy_document" "ec2_admin_permissions" {
  statement {
    effect    = "Allow"
    actions   = ["ec2:*"]
    resources = ["*"]
  }
}

# Utworzenie egzemplarza profilu z dołączoną rolą IAM.
resource "aws_iam_instance_profile" "instance" {
  role = aws_iam_role.instance.name
}
